
import muse3glike, cobaya.likelihood, cobaya.typing

class spt3g_2yr_delensed_ee_optimal_pp_muse(
    cobaya.likelihood.Likelihood, 
    muse3glike.spt3g_2yr_delensed_ee_optimal_pp_muse
):

    components: cobaya.typing.Sequence[str] = None
    filename: str = None

    def __init__(self, *args, **kwargs):
        cobaya.likelihood.Likelihood.__init__(self, *args, **kwargs)

    def initialize(self):
        muse3glike.spt3g_2yr_delensed_ee_optimal_pp_muse.__init__(self, filename=self.filename, components=self.components)

    def get_requirements(self):
        # shouldnt need unlensed_Cl if "EE" not in self.components but
        # seems to be a bug in Cobaya finding a starting point if we
        # don't request it anyway
        requirements = {'unlensed_Cl': {'ee': 5000}}
        if "ϕϕ" in self.components:
            requirements['Cl'] = {'pp': 3000}
        return requirements

    def logp(self, **kwargs):
        ℓ_slice = slice(self.BPWF["ℓ"][0], self.BPWF["ℓ"][-1] + 1)
        return self.loglike({
            "EE": self.provider.get_unlensed_Cl(ell_factor=False)["ee"][ℓ_slice] if "EE" in self.components else None,
            "ϕϕ": self.provider.get_Cl(ell_factor=False)["pp"][ℓ_slice] if "ϕϕ" in self.components else None
        })