

ENV["VIRTUAL_ENV"]=joinpath(@__DIR__, "../.venv")
ENV["JULIA_CONDAPKG_BACKEND"] = "Null"
ENV["JULIA_PYTHONCALL_EXE"] = joinpath(@__DIR__, "../.venv/bin/python")

using ForwardDiff, Muse3GLike, PythonCall, Test


@testset "Julia/Python consistency" begin

    @testset "components = $components" for components in [("ϕϕ", "EE"), ("ϕϕ", "EE", "Acals", "ψpols", "βs", "ϵqs", "ϵus")]

        spt_jl = Muse3GLike.spt3g_2yr_delensed_ee_optimal_pp_muse(;components=Symbol.(components))
        x_jl = Muse3GLike.example_inputs(spt_jl)
        
        spt_py = pyimport("muse3glike").spt3g_2yr_delensed_ee_optimal_pp_muse(;components)
        x_py = spt_py.example_inputs()

        @test x_jl ≈ PyArray(spt_py.tovec(x_py))  

        @test Muse3GLike.loglike(spt_jl, x_jl) ≈
            PyArray(spt_py.loglike(x_py))[1]
            
        @test ForwardDiff.gradient(x -> Muse3GLike.loglike(spt_jl, x), x_jl) ≈
            PyArray(spt_py.tovec(pyimport("jax").grad(spt_py.loglike)(x_py))) rtol=1e-2

    end

end