try:
    # more recent versions
    from cobaya.likelihoods.base_classes import CMBlikes
except ImportError:
    from cobaya.likelihoods._base_classes import _CMBlikes as CMBlikes


import os
import numpy as np
from typing import List
from getdist import ParamNames, IniFile
from scipy.linalg import sqrtm

# import string, random
    
class SPT3GLensing(CMBlikes):
    # You can either keep data separate and set install_options for where to download from, or
    # (if not too big) bundle the data in the package, so don't need separate install as here
    install_options = {}

    
    
class SPTLensLike(CMBlikes):

    def init_params(self, ini):
        super().init_params(ini)
            
        # FG Template ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if 'foreground_template_file' in ini.params:
            self.fgnd_template = self.read_cl_array(ini, 'foreground_template')
        else:
            self.fgnd_template = None
        
    def log_likelihood(self, dls, **data_params):
        r"""
        Get log likelihood from the dls (CMB C_l scaled by L(L+1)/2\pi)
        :param dls: dictionary of d_l ('tt', etc)
        :param data_params: likelihood nuisance parameters
        :return: log likelihood
        """
        self.get_theory_map_cls(dls, data_params)
        C = np.empty((self.nmaps, self.nmaps))
        big_x = np.empty(self.nbins_used * self.ncl_used)
        vecp = np.empty(self.ncl)
        chisq = 0
        if self.binned:
            binned_theory =  data_params.get("Aphiphi")*self.get_binned_map_cls(self.map_cls)
            if self.fgnd_template is not None:
                binned_theory += data_params.get("A_fg")*self.fgnd_template.T
                print(binned_theory.flatten())
        else:
            Cs = np.zeros((self.nbins_used, self.nmaps, self.nmaps))
            for i in range(self.nmaps):
                for j in range(i + 1):
                    CL = self.map_cls[i, j]
                    if CL is not None:
                        Cs[:, i, j] = CL.CL[self.bin_min - self.pcl_lmin:
                                            self.bin_max - self.pcl_lmin + 1]
                        Cs[:, j, i] = CL.CL[self.bin_min - self.pcl_lmin:
                                            self.bin_max - self.pcl_lmin + 1]
        for b in range(self.nbins_used):
            if self.binned:
                self.elements_to_matrix(binned_theory[b, :], C)
            else:
                C[:, :] = Cs[b, :, :]
            if self.cl_noise is not None:
                C += self.noise_matrix[b]
            if self.like_approx == 'exact':
                chisq += self.exact_chi_sq(
                    C, self.bandpower_matrix[b], self.bin_min + b)
                continue
            elif self.like_approx == 'HL':
                try:
                    self.transform(
                        C, self.bandpower_matrix[b], self.fiducial_sqrt_matrix[b])
                except np.linalg.LinAlgError:
                    self.log.debug("Likelihood computation failed.")
                    return -np.inf
            elif self.like_approx == 'gaussian':
                C -= self.bandpower_matrix[b]
            self.matrix_to_elements(C, vecp)
            big_x[b * self.ncl_used:(b + 1) * self.ncl_used] = vecp[
                self.cl_used_index]
        if self.like_approx == 'exact':
            return -0.5 * chisq

        return -0.5 * self._fast_chi_squared(self.covinv, big_x)
